program define minimax

capture mac drop _all
capture clear
quietly set more off, permanently
quietly set matsize 5000, permanently

display "{res}{hline}" 
display "{res}{hline}" 
display _newline(1)
display _col(15)  "{res}{ul on}{hilite}{it:''Minimax Regret in Practice: Four Examples on Treatment Choice''}{ul off}"
display _newline(1)
display _col(25) "{res}{it: STATA code}"
display _newline(1)
display _col(15) "{txt}by Patrick Eozenou, Javier Rivas and Karl Schlag"
display _col(20) "{res}2006 - Copyrights reserved -"
display _newline(1)
display "{res}{hline}"
display "{res}{hline}" 
display _newline(8)

/// PRELIMINARIES ///

global treat1 "treat1"
global treat2 "treat2"
global n1 "n1"
global n2 "n2"
global low_int "low_int"
global up_int "up_int"
global accuracy "accuracy"
global PS "PS"
global VR "VR"
global cost1 "cost1"
global cost2 "cost2"

						/////////////////////
						/////	STEP 1	/////
						/////////////////////

display as txt "{hline}"
display as txt "{hilite}STEP 1" ": Loading the data for treatment 1 and for treatment 2"
display as txt "{hline}"

capture confirm file $treat1

display _newline(1)
display  as result "Enter the name of the {hilite:DATA FILE} containing {hilite:treatment 1}"
display  as result "You should type something like {it:{hilite}filename1.dta}"
display as result "(Take care that the dataset for treatment 1 contains at least as much observation as for treatment 2)"
display _newline(1)
while _rc != 0 {
	display as txt "What is the data file for treatment 1?" _request(treat1)
	capture confirm file $treat1
}

use $treat1

egen miss = rowmiss(var1)
egen missing = sum(miss)
if (missing[1] > 0) {
display _newline(1)
display as error "Error: The dataset for treatment 1 must not contain missing values"
display as result "--> Remove the missing observations"
display _newline(1)
display as txt "Exit program"
exit
}
else {
}
drop miss**
global n1 = _N

display _newline(1)
display  as result "Choose a name for the {hilite:VARIABLE} contained in the data file {hilite:$treat1}"
display _newline(1)
display as txt "What is the name of the variable for treatment 1?"
display _request(name1)

local name1 "$name1"
rename var1 $name1
mkmat $name1
save temp1.dta, replace
 
capture confirm file $treat2

display _newline(1)
display  as result "Now do the same for {hilite:treatment 2}, enter the name of the {hilite:DATA FILE} first {it:{hilite}(filename2.dta)}"
display _newline(1)
while _rc != 0 {
	display as txt "What is the data file for treatment 2?" _request(treat2)
	capture confirm file $treat2
}

use $treat2

egen miss = rowmiss(var1)
egen missing = sum(miss)
if (missing[1] > 0) {
display _newline(1)
display as error "Error: The dataset for treatment 2 must not contain missing values"
display as result "--> Remove the missing observations"
display _newline(1)
display as txt "Exit program"
exit
}
else {
}
drop mis**
global n2 = _N

display _newline(1)
display  as result "Then choose a name for the {hilite:VARIABLE} contained in the data file {hilite:$treat2}"
display _newline(1)
display as txt "What is the name of the variable for treatment 2?"
display _request(name2)

local name1 "$name2"
rename var1 $name2
mkmat $name2 
save temp2.dta, replace

if ($n1 < $n2) {
display _newline(1)
display as error "Error: The dataset for treatment 1 must be the one with the highest number of observations"
display as result "--> You should swap datasets"
display _newline(1)
display as txt "Exit program"
exit 198
}
else {
}

						/////////////////////
						/////	STEP 2	/////
						/////////////////////

display _newline(1)
display as txt "{hline}"
display as txt "{hilite}STEP 2" ": Range of values"
display as txt "{hline}"

capture confirm number $low_int

display _newline(1)
display  as result "Enter the admissible {hilite:lower-interval} value for your data"
display _newline(1)
while _rc !=0 {
	display as txt "What is the value for the lower interval?" _request(low_int)
	capture confirm number $low_int
}

global low = $low_int

capture confirm number $up_int

display _newline(1)
display  as result "Enter the admissible {hilite:upper-interval} value for your data"
display _newline(1)
while _rc !=0 {
	display as txt "What is the value for the upper interval?" _request(up_int)
	capture confirm number $up_int
}

global up = $up_int

						/////////////////////
						/////	STEP 3	/////
						/////////////////////

display _newline(1)
display as txt "{hline}"
display as txt "{hilite}STEP 3" ": Method"
display as txt "{hline}"

capture confirm number $VR

display _newline(1)
display  as result "Choose here between the Binomial Average Rule or the Correlated Binomial Average Rule"
display as result "If you want to implement the {hilite}Binomial Average Rule"", type {hilite}0"
display as result "If you want instead to implement the {hilite}Correlated Binomial Average Rule"", type {hilite}1"
display _newline(1)
while _rc !=0 {
	display as txt "Which method do you choose?" _request(VR)
	capture confirm number $VR
}


						/////////////////////
						/////	STEP 4	/////
						/////////////////////

display _newline(1)
display as txt "{hline}"
display as txt "{hilite}STEP 4" ": Paired Experiment"
display as txt "{hline}"

capture confirm number $PS

display _newline(1)
display  as result "Indicate whether your data come from a {hilite:paired experiment}"
display  as result "(see section 2.2.4 in the paper)"
display "{hilite}(1:yes / 0:no)"
display _newline(1)
while _rc !=0 {
	display as txt "The data come from a paired experiment?" _request(PS)
	capture confirm number $PS
}

						/////////////////////
						/////	STEP 5	/////
						/////////////////////

display _newline(1)
display as txt "{hline}"
display as txt "{hilite}STEP 5" ": Accuracy"
display as txt "{hline}"

capture confirm number $accuracy

display _newline(1)
display  as result "Choose the level of {hilite:accuracy} of the recommandation"
display  as result "Enter here an even number ({hilite:4} yields about 2 decimals accuracy)"
display  as err "Warning: " "{res}when choosing a level of accuracy higher than 4,"
display  as result "computing time becomes quite important for unbalanced samples or paired samples."
display _newline(1)
while _rc !=0 {
	display as txt "Accuracy?" _request(accuracy)
	capture confirm number $accuracy
}

local floor = floor($accuracy/2)
local ceil = ceil($accuracy/2)

if (`floor' != `ceil') {
disp "{err}Error: ''Accuracy'' must be an even number"
disp "{res}--> Run again minimax and check that ''Accuracy'' is an even number"
disp "{txt}Exit program"
exit 198
}

						/////////////////////
						/////	STEP 6	/////
						/////////////////////

display _newline(1)
display as txt "{hline}"
display as txt "{hilite}STEP 6" ": Unitary Costs"
display as txt "{hline}"

capture confirm number $cost1

display _newline(1)
display  as result "Choose whether you want to include a {hilite}cost for treatment 1"
display _newline(1)
while _rc !=0 {
	display as txt "Cost for treatment 1?" _request(cost1)
	capture confirm number $cost1
}
display _newline(1)

capture confirm number $cost2

display _newline(1)
display  as result "Choose whether you want to include a {hilite}cost for treatment 2"
display _newline(1)
while _rc !=0 {
	display as txt "Cost for treatment 2?" _request(cost2)
	capture confirm number $cost2
}

						/////////////////////
						/////	REGRET	/////
						/////////////////////

matrix regret = J(1,1,.)
matrix regret[1,1] = 0.17 / (((2*$n2) - 1)^(1/2))

						/////////////////////
						/////	COSTS	/////
						/////////////////////

if ($cost1 < $cost2) {
matrix min = $cost1
matrix max = $cost2
global up_int = $up_int - min[1,1]
global low_int = $low_int - max[1,1]
matrix $name1 = $name1 - $cost1*J($n1,1,1)
matrix $name2 = $name2 - $cost2*J($n2,1,1)
}
else if ($cost1 > $cost2) {
matrix min = $cost2
matrix max = $cost1
global up_int = $up_int - min[1,1]
global low_int = $low_int - max[1,1]
matrix $name1 = $name1 - $cost1*J($n1,1,1)
matrix $name2 = $name2 - $cost2*J($n2,1,1)
}
else if ($cost1 == $cost2) {
matrix min = $cost1
matrix max = $cost2
global up_int = $up_int - min[1,1]
global low_int = $low_int - max[1,1]
matrix $name1 = $name1 - $cost1*J($n1,1,1)
matrix $name2 = $name2 - $cost2*J($n2,1,1)
}

						/////////////////////
						/////	LAUNCH	/////
						/////////////////////

display _newline(3)

if ($VR == 0 & $PS == 0) {
m_BAR
}
else if ($VR == 1 & $PS == 0) {
m_CBAR
}
else if ($VR == 0 & $PS == 1) {
m_BAR_PS
}
else if ($VR == 1 & $PS == 1) {
m_CBAR_PS
}
else {
dis  "{err}Error: ''method'' and ''paired sample'' choices must be binary (0/1) variables"
dis "{res}--> Run again minimax and check carefully the inputs"
dis "{txt}Exit program"
exit 198
}

end
